package com.hero.objects.modifiers;

import java.util.ArrayList;
import java.util.Collections;

import org.jdom.Element;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.GenericObject;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class Invisible extends Modifier {
	private static String xmlID = "INVISIBLE";

	public Invisible(Element root) {
		super(root, Invisible.xmlID);
	}

	@Override
	public ArrayList<Adder> getAssignedAdders() {
		if (HeroDesigner.getActiveTemplate().is6E()) {
			return super.getAssignedAdders();
		}
		ArrayList<Adder> ret = super.getAssignedAdders();
		GenericObject p = getProgenitor();
		if ((p != null)
				&& p.getTypes().contains("MENTAL")
				&& (GenericObject.findObjectByID(p.getAssignedModifiers(),
						"BASEDONCON") == null)
				&& (GenericObject.findObjectByID(p.getAssignedModifiers(),
						"BOECV") == null)) {
			return new ArrayList<Adder>();
		}
		return ret;
	}

	@Override
	public ArrayList<Adder> getAvailableAdders() {
		if (HeroDesigner.getActiveTemplate().is6E()) {
			return super.getAvailableAdders();
		}
		ArrayList<Adder> ret = super.getAvailableAdders();
		GenericObject p = getProgenitor();
		if ((p != null)
				&& p.getTypes().contains("MENTAL")
				&& (GenericObject.findObjectByID(p.getAssignedModifiers(),
						"BASEDONCON") == null)
				&& (GenericObject.findObjectByID(p.getAssignedModifiers(),
						"BOECV") == null)) {
			return new ArrayList<Adder>();
		}
		return ret;
	}

	@Override
	public String getColumn2Output() {
		if (HeroDesigner.getActiveTemplate().is6E()) {
			String adderString = "";
			String ret = "";
			ret += getAlias();
			
			double val = getTotalValue();
			adderString = getAdderString();
			
			for (Modifier mod : getAssignedModifiers()) {
				ret += ", " + mod.getAlias();
			}
			ret += " (";
			if (getSelectedOption().getAlias().startsWith("Obvious Power,")) {
				ret += getSelectedOption().getAlias().substring(14, getSelectedOption().getAlias().length()).trim();
			} else if (getSelectedOption().getAlias().startsWith("Inobvious Power,")) {
				ret += getSelectedOption().getAlias().substring(16, getSelectedOption().getAlias().length()).trim();
			} else {
				ret += getSelectedOption().getAlias().trim();
			}
			Adder effectsTarget = (Adder)findObjectByID(getAssignedAdders(), "EFFECTSTARGET");
			Adder effectsOther = (Adder)findObjectByID(getAssignedAdders(), "EFFECTSOTHER");
			if (effectsTarget != null && effectsOther != null) {
				effectsTarget.setDisplayInString(false);
				effectsOther.setDisplayInString(false);
				if (effectsTarget.getSelectedOption().getXMLID().equals("DEFAULT")) {
					if (effectsOther.getSelectedOption().getXMLID().equals("DEFAULT")) {
						//do nothing
					} else { //effectsOther set...
						ret += ", effects of Power are "+effectsOther.getSelectedOption().getAlias()+" to other characters";
					}
				} else if (effectsOther.getSelectedOption().getXMLID().equals("DEFAULT")) {
					//effectsTarget set...
					ret += ", effects of Power are "+effectsTarget.getSelectedOption().getAlias()+" to target";
				} else {
					//both set
					if (effectsTarget.getSelectedOption().getXMLID().equals(effectsOther.getSelectedOption().getXMLID())) {
						ret += ", effects of Power are "+effectsTarget.getSelectedOption().getAlias()+" to both target and other characters";
					} else {
						ret += ", effects of Power are "+effectsTarget.getSelectedOption().getAlias()+" to target and "
							+ effectsOther.getSelectedOption().getAlias()+" to other characters";
					}
				}
			}
			ret += "; ";
			if (adderString.trim().length() > 0) {
				ret += adderString+"; ";
			}
			ret += getFraction(val) + ")";
			
			return ret;
		} else {
			String adderString = "";
			String ret = "";
			ret += getAlias();
			String senses = "";
			if ((getSelectedOption() == null)
					|| getSelectedOption().getXMLID().equals("FULL")
					|| ((getProgenitor() != null)
							&& getProgenitor().getTypes().contains("MENTAL")
							&& (GenericObject.findObjectByID(getProgenitor()
									.getAssignedModifiers(), "BASEDONCON") == null)
							&& (GenericObject.findObjectByID(getProgenitor()
									.getAssignedModifiers(), "BOECV") == null) && getSelectedOption()
							.getAlias().equals("Fully Invisible"))) {
				senses = "Fully Invisible";
			} else {
				ArrayList<String> selectedSenses = new ArrayList<String>();
				ArrayList<String> selectedGroups = new ArrayList<String>();
				if (getSelectedOption().getXMLID().equals("SINGLE")) {
					selectedSenses.add(getSelectedOption().getAlias());
				} else {
					String gr = getSelectedOption().getAlias();
					if (gr.toUpperCase().indexOf("GROUP") > 0) {
						gr = gr.substring(0, gr.toUpperCase().indexOf("GROUP"))
								.trim();
					}
					selectedGroups.add(gr);
				}
				for (Adder ad : getAssignedAdders()) {
					if (ad.getXMLID().equals("ADDITIONALSENSE")
							&& (ad.getSelectedOption() != null)
							&& (ad.getSelectedOption().getAlias().trim()
									.length() > 0)) {
						selectedSenses.add(ad.getSelectedOption().getAlias());
						ad.setDisplayInString(false);
					} else if (ad.getXMLID().equals("ADDITIONALGROUP")
							&& (ad.getSelectedOption() != null)
							&& (ad.getSelectedOption().getAlias().trim()
									.length() > 0)) {
						String gr = ad.getSelectedOption().getAlias();
						if (gr.toUpperCase().indexOf("GROUP") > 0) {
							gr = gr.substring(0,
									gr.toUpperCase().indexOf("GROUP")).trim();
						}
						selectedGroups.add(gr);
						ad.setDisplayInString(false);
					}
				}
				Collections.sort(selectedSenses);
				Collections.sort(selectedGroups);
				String val = "";
				int count = -1;
				for (String s : selectedSenses) {
					count++;
					if (val.trim().length() > 0) {
						val += ", ";
					}
					if ((count == selectedSenses.size() - 1)
							&& (selectedGroups.size() == 0) && (count > 0)) {
						val += "and ";
					}
					val += s;
				}
				count = -1;
				for (String s : selectedGroups) {
					count++;
					if (val.trim().length() > 0) {
						val += ", ";
					}
					if ((count == selectedGroups.size() - 1)
							&& (selectedGroups.size() + selectedSenses.size() > 1)) {
						val += "and ";
					}
					val += s;
					if (count == selectedGroups.size() - 1) {
						val += " Group";
						if (selectedGroups.size() > 1) {
							val += "s";
						}
					}
				}
				if (val.trim().length() > 0) {
					ret = "Invisible to " + val;
				}
			}
			double val = getTotalValue();
			adderString = getAdderString();
			if ((getInput() != null) && (getInput().trim().length() > 0)) {
				if (ret.trim().length() > 0) {
					ret += ":  ";
				}
				ret += getInput();
			}
			for (Modifier mod : getAssignedModifiers()) {
				ret += ", " + mod.getAlias();
			}
			ret += " (";
			if (senses.trim().length() > 0) {
				ret += senses;
				ret += "; ";
			}
			if (getComments().trim().length() > 0) {
				ret += getComments() + "; ";
			}
			ret += getFraction(val) + ")";
			if (adderString.trim().length() > 0) {
				if (ret.trim().length() > 0) {
					ret += ", ";
				}
				ret += adderString;
			}
			return ret;
		}
	}

	@Override
	public ArrayList<Adder> getOptions() {
		ArrayList<Adder> ret = super.getOptions();
		GenericObject p = getProgenitor();
		if ((p != null)
				&& p.getTypes().contains("MENTAL")
				&& (GenericObject.findObjectByID(p.getAssignedModifiers(),
						"BASEDONCON") == null)
				&& (GenericObject.findObjectByID(p.getAssignedModifiers(),
						"BOECV") == null)) {
			for (Adder ad : ret) {
				if (ad.getXMLID().equals("MENTAL")) {
					try {
						ad = (Adder) ad.clone();
						ad.setAlias("Fully Invisible");
						if (ad.getBaseCost() < .5 && !HeroDesigner.getActiveTemplate().is6E()) {
							ad.setBaseCost(.5);
						}
						setSelectedOption(ad);
						ret = new ArrayList<Adder>();
						ret.add(ad);
						return ret;
					} catch (Exception exp) {
					}
				}
			}
		}
		return ret;
	}

	@Override
	public Adder getSelectedOption() {
		getOptions(); // resets selection if Mental Power...
		return super.getSelectedOption();
	}

	@Override
	public String included(GenericObject o) {
		String ret = super.included(o);
		if (ret.trim().length() > 0) {
			return ret;
		}

        if (forceAllow()) return ret;
		if (o.getTypes().contains("MENTAL")) {
			return "";
		}
		
		if (!HeroDesigner.getActiveTemplate().is6E() && !o.isVisible()) {
			return o.getDisplay() + " is already invisible.";
		}
		
		if (GenericObject.findObjectByID(o.getAssignedModifiers(), "VISIBLE") != null) {
			return getDisplay()
					+ " cannot be applied to a Power/ability with the Visible Limitation on it.";
		}
		return "";
	}

	@Override
	public void setSelectedOption(Adder val) {
		super.setSelectedOption(val);
		if ((val != null) && val.getXMLID().equals("FULL")) {
			setAssignedAdders(new ArrayList<Adder>());
		}
	}
}